/**
 * This file is a part of JSIDPlay - a Java SID Player
 * Main Developer: Joakim Eriksson (Dreamfabric.com)
 * Contact: joakime@sics.se
 * Web: http://www.dreamfabric.com/c64
 * ---------------------------------------------------
 */

package applet;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;

import javax.swing.JComponent;

/**
 * Animates the status of the PSID extra sample channel
 * 
 * 
 * Created: Tue Aug 02 14:53:07 2005
 * 
 * @author <a href="mailto:Joakim@BOTBOX"></a>
 * @version 1.0
 */
public class PSIDCanvas extends JComponent {

	private static final int CUTOFF_SIZE = 81;
	private static final int RESONANCE_SIZE = 81;
	private static final int SAMPLE_SIZE = 110;

	private int[] cutoffBuffer = new int[CUTOFF_SIZE];
	private int[] resonanceBuffer = new int[RESONANCE_SIZE];
	private int[] sampleBuffer = new int[SAMPLE_SIZE];
	private int cutoffPos;
	private int resonancePos;

	private static final Color PENCOLOR = new Color(0x00c000);
	private static final Color BORDERCOLOR = new Color(0x204020);

	public PSIDCanvas() {
		super();
		setFont(new Font("Monospaced", Font.PLAIN, 10));
		setForeground(Color.green);
		setBackground(Color.black);
		setOpaque(true);
		setDoubleBuffered(true);
	}

	public Dimension getPreferredSize() {
		return new Dimension(110 + CUTOFF_SIZE + RESONANCE_SIZE + 10, 80);
	}

	public void updateFilter(int cutoff, int resonance) {
		cutoffBuffer[cutoffPos] = cutoff >> 5;
		cutoffPos = (cutoffPos + 1) % CUTOFF_SIZE;

		resonanceBuffer[resonancePos] = resonance << 2;
		resonancePos = (resonancePos + 1) % RESONANCE_SIZE;
	}

	public void paintComponent(Graphics g) {
		boolean quiet = true;
		int height = getHeight();
//		if (psid.lastPlayedSample < 4) {
//			quiet = false;
//			int playPos = psid.playSamplePos;
//			if (playPos + (SAMPLE_SIZE << 3) > psid.sampleEnd) {
//				playPos = psid.sampleEnd - (SAMPLE_SIZE << 3);
//				if (playPos < 0)
//					playPos = 0;
//			}
//			for (int i = 0, n = SAMPLE_SIZE; i < n; i++) {
//				sampleBuffer[i] = psid.buffer[(i << 3) + playPos];
//			}
//		}

		g.setColor(PENCOLOR);
		g.drawString("Sample Output", 6, 10);
		if (!quiet) {
			for (int i = 0, n = SAMPLE_SIZE - 1; i < n; i++) {
				g.drawLine(i, height - 10 - height * ((sampleBuffer[i]) >> 1)
						/ 128, i + 1, height - 10 - height
						* ((sampleBuffer[i + 1]) >> 1) / 128);
			}
		}

		int pos = 115;
		g.drawString("Flt.Cutoff", pos, 10);
		for (int i = 0, n = CUTOFF_SIZE - 1; i < n; i++) {
			int ix = (cutoffPos + i + CUTOFF_SIZE) % CUTOFF_SIZE;
			g.drawLine(pos + i, height - 10 - height * cutoffBuffer[ix] / 128,
					i + pos + 1, height - 10 - height
							* cutoffBuffer[(ix + 1) % CUTOFF_SIZE] / 128);
		}

		pos += CUTOFF_SIZE + 5;
		g.drawString("Flt.Res.", pos, 10);
		for (int i = 0, n = RESONANCE_SIZE - 1; i < n; i++) {
			int ix = (resonancePos + i + RESONANCE_SIZE) % RESONANCE_SIZE;
			g.drawLine(pos + i, height - 10 - height * resonanceBuffer[ix]
					/ 128, i + pos + 1, height - 10 - height
					* resonanceBuffer[(ix + 1) % RESONANCE_SIZE] / 128);
		}

		// g.drawString("B%", 6, 10);
		// double bl = mixer.getBufferLevel();
		// g.fillRect(3, height - (int)(height * bl / 110), 6, height - 10);

	}
}
